unit RingScope03;
// ====================================================================
(*
                     
                       ( TRingScope)

          TCustomScope
       (. unit CustomScope03).

    TRingScope     
   ( Value)      
         ,  
     Value.   
       "  ",  
   "  "  .
           
   ,       ( ,
       ).
           
     TImage ( -  Image).

      // -----------------------------------------------------
      // ,    
      // -----------------------------------------------------
      MinScope    -    (   0)
      MaxScope    -   (   0)
      // -----------------------------------------------------
      //    
      // -----------------------------------------------------
      ScopeName   -   ()
      Measure     -    
      // -----------
      //     
      P2Wall      -       ( 0)
      P1Wall      -      ( 0)
      N1Wall      -      ( 0)
      N2Wall      -       ( 0)
      WallStyle   -      
      // -----------
      NumLPF      -     ( 0)
      // -----------
      XBeg        - X- ( )    Image
      YBeg        - Y- ( )    Image
      // -----------
      ScopeStyle  -   (ssArc -, ssPie - )
      Transparent -  
      // -----------------------------------------------------
      //     
      // -----------------------------------------------------
      Visible     -  
      Value       -    

           unit CustomScope03
    type TCustomScope = class(TObject)

   // -----------------------------------------------------
   //   :
   Scope := TRingScope.Create(Image1, RqXB, RqYB);
   // -----------------------------------------------------
   //     :
   if Assigned(Scope) then Scope.Value := ...;   //  
   // :  NumLPF = 0,    
   //             .  NumLPF >= 2,   
   //                 (NumLPF)   
   //              .
   // -----------------------------------------------------
    3.5. ()  , , , 2017..2020 .
               () Source code  ..
     27.12.2019
*)
// ====================================================================

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls,
  Math,
  CommonDEF03, CustomScope03;

// =========================================================================
//   TRingScope
// =========================================================================

type TRingScope = class(TCustomScope)
private
    // ------------
    fScSize        : integer;      //    
    // ------------
    fX0            : integer;      // X-   
    fY0            : integer;      // Y-   
    // ------------
    fRadiusOUT     : integer;      //   
    fRadiusMarks   : integer;      //   
    fRadiusARC     : integer;      //  ARC 
    fRadiusPIE     : integer;      //  PIE 
    fRadiusIN      : integer;      //   
    // ------------
    fPn1           : TPoint;       //  1  
    fPn2           : TPoint;       //  2  
    // ------------
    //      
    procedure BmpRingClear(RqBmp : TBitMap);
    //     
    procedure BmpShowMarks(RqBmp : TBitMap; RqValue : extended);
    //    
    procedure CalcPn1Pn2(RqRadius : Integer; RqValue : extended);
    //   
    procedure BmpShowRing(RqBmp : TBitMap; RqValue : extended);
    // ---------------
protected
    //       
    procedure ReSizeScope();  override;
    //   
    procedure PaintToBmp(Bmp : TBitMap); override;
public
    // ---------------
    constructor Create(RqImg : TImage; RqXB, RqYB : integer);
    procedure Free();
    // ---------------
end;

// =========================================================================
// =========================================================================

implementation

// =========================================================================
//  TRingScope.  
// =========================================================================
const RingMinSize    = 110;  //    
      RingWidth      = 20;   //     
const MaxAngleRange  = Pi * 3 / 2;  //    
// ================================================================
//    TRingScope.  / 
// ================================================================
// ----------------------------------------------------------------
constructor TRingScope.Create(RqImg : TImage; RqXB, RqYB : integer);
begin
   inherited Create(RqImg, RqXB, RqYB, RingMinSize, RingMinSize);
   // --------------------
   fScSize     := RingMinSize;
   // --------------------
   fX0  := fScSize div 2;
   fY0  := fScSize div 2;
   // --------------------
   //     
   fRadiusOUT   := (fScSize div 2);
   fRadiusMarks := fRadiusOUT - (RingWidth div 3);
   fRadiusARC   := fRadiusOUT - 2 * (RingWidth div 3);
   fRadiusIN    := fRadiusOUT -RingWidth;
   fRadiusPIE   := fRadiusIN;
   // --------------------
   ScopeStyle   := ssARC;           //  
   Transparent  := True;            //  
   // --------------------
   ScopeName    := 'Ring';          //  
   Measure      := '(mV)';          //  
   MinScope     := -100;
   MaxScope     :=  100;
   //       
   WallStyle   := wsNotUse;
   Value       := 0;
   // --------------------
   //  
   Visible := True;
end;
// ----------------------------------------------------------------
procedure TRingScope.Free();
begin
    // ---------------
    //  
    Visible :=False;
    // ---------------
    inherited Free;
    // ---------------
end;
// ================================================================
//   TRingScope.   .
// ================================================================
// ----------------------------------------------------------------
//   
procedure TRingScope.BmpRingClear(RqBmp : TBitMap);
begin
  with RqBMP.Canvas
  do begin
    Pen.Width   := 1;
    Pen.Style   := psSolid;
    Pen.Color   := clBlack;
    Brush.Color := RGB(160,180,200);
    if Transparent
    //   
    then Brush.Style := bsClear
    else Brush.Style := bsSolid;
    //  
    Ellipse(0, 0, fScSize, fScSize);
    //  
    Ellipse(fX0 - fRadiusPIE, fY0 + fRadiusPIE,
            fX0 + fRadiusPIE, fY0 - fRadiusPIE);
  end;
end;
// ----------------------------------------------------------------
//     
procedure TRingScope.BmpShowMarks(RqBmp : TBitMap; RqValue : extended);
const cMarkNum = 30;
var   wVRange : extended;            //   
      wVStep,  wAStep  : extended;   //      
      wVCount, wACount : extended;   //    
      wColor  : TColor;              //  
      wSin, wCos : extended;         //   
begin
    if not ((MaxScope - MinScope) > 0) then Exit;
    //    
    if Abs(MaxScope) >= Abs(MinScope)
    then wVRange := Abs(MaxScope)
    else wVRange := Abs(MinScope);
    //        
    wVStep := Abs(wVRange) / cMarkNum;
    wAStep := MaxAngleRange / cMarkNum;
    //       
    if RqValue < 0
    then begin
         wAStep := -wAStep;
         wVRange := Abs(MinScope);
    end else wVRange := Abs(MaxScope);
    //  
    //     
    with BMP.Canvas
    do begin
      Pen.Width   := 3;
      Pen.Style   := psSolid;
      Brush.Style := bsClear;
      wVCount := 0;
      wACount := 0;
      while ((Abs(wACount) <= MaxAngleRange) and (wVCount <= wVRange))
      do begin
          //   
          SinCos(wACount, wSin, wCos);
          fPn1.X := Round((fRadiusMarks) * wCos);
          fPn1.Y := Round((fRadiusMarks) * wSin);
          //  
          if RqValue >= 0
          //   
          then wColor := GetColorByValue(csDark,   wVCount)
          else wColor := GetColorByValue(csDark,  -wVCount);
          if wVCount = 0 then wColor := clBlack;
          Pen.Color   := wColor;
          Ellipse(fX0 + fPn1.X - 1, fY0 - (fPn1.Y - 1),
                    fX0 + fPn1.X + 1, fY0 - (fPn1.Y + 1));
          wVCount := wVCount + wVStep;
          wACount := wACount + wAStep;
      end;
    end;
end;
// ----------------------------------------------------------------
//    
procedure TRingScope.CalcPn1Pn2(RqRadius : Integer; RqValue : extended);
var   wMax       : extended;
      wAngle     : extended;
      wSin, wCos : extended;
begin
   if RqRadius < 1 then Exit;
   if Abs(MaxScope) >= Abs(MinScope)
   then wMax := MaxScope else wMax := Abs(MinScope);
   wAngle := MaxAngleRange * Value / wMax;
   //    
   fPn1.X := RqRadius;
   fPn1.Y := 0;
   //    
   SinCos(wAngle, wSin, wCos);
   fPn2.X := Round(RqRadius * wCos);
   fPn2.Y := Round(RqRadius * wSin);
end;
// ----------------------------------------------------------------
//   
// 17.03.2018       
procedure TRingScope.BmpShowRing(RqBmp : TBitMap; RqValue : extended);
const MaxNameLen = 8;
var  wRadius : integer;
     wColor  : TColor;
     WTxtH   : integer;
     WTxtW   : integer;
     wYV,wTM : integer;
     wName   : string;
begin
     with RqBMP.Canvas
     do begin
        // -------------------------------------
        //   
        if ScopeStyle = ssARC
        then begin
           //    
           wRadius := fRadiusARC;
           CalcPn1Pn2(wRadius, RqValue);
           Pen.Width   := 3;
           Brush.Style := bsClear;
           //   
           wColor := GetColorByValue(csDark,  RqValue);
           //  
           if not ((fPn1.X = fPn2.X) and (fPn1.Y = fPn2.Y))
           //     
           then begin
              if RqValue > 0
              then begin //    
                    Pen.Color := wColor;
                    Arc   (fX0 - wRadius, fY0 - wRadius,
                           fX0 + wRadius, fY0 + wRadius,
                           fX0 + fPn1.X, fY0 - fPn1.Y,
                           fX0 + fPn2.X, fY0 - fPn2.Y);
              end
              else begin //    
                    Pen.Color := wColor;
                    Arc   (fX0 - wRadius, fY0 - wRadius,
                           fX0 + wRadius, fY0 + wRadius,
                           fX0 + fPn2.X, fY0 - fPn2.Y,
                           fX0 + fPn1.X, fY0 - fPn1.Y);
              end;
           end;
        end;
        // -------------------------------------
        //   
        if ScopeStyle = ssPIE
        then begin
           //    
           wRadius := fRadiusARC;
           CalcPn1Pn2(wRadius, RqValue);
           //   
           wColor := GetColorByValue(csLight, RqValue);
           //  
           wRadius     := fRadiusPIE;
           Pen.Width   := 1;
           Pen.Color   := wColor;
           Pen.Style   := psSolid;
           Brush.Style := bsSolid;
           if not ((fPn1.X = fPn2.X) and (fPn1.Y = fPn2.Y))
           //     
           then begin
              if RqValue > 0
              then begin //   
                  Pen.Color := wColor;
                  Brush.Color := wColor;
                  Pie   (fX0 - wRadius, fY0 - wRadius,
                         fX0 + wRadius, fY0 + wRadius,
                         fX0 + fPn1.X, fY0 - fPn1.Y,
                         fX0 + fPn2.X, fY0 - fPn2.Y);
              end
              else begin //   

                  Pen.Color := wColor;
                  Brush.Color := wColor;
                  Pie   (fX0 - wRadius, fY0 - wRadius,
                         fX0 + wRadius, fY0 + wRadius,
                         fX0 + fPn2.X, fY0 - fPn2.Y,
                         fX0 + fPn1.X, fY0 - fPn1.Y);
              end;
           end;
           //    
           Pen.Width   := 2;
           Pen.Style   := psSolid;
           Pen.Color   := clBlack;
           MoveTo (fX0, fY0);
           LineTo (fX0 + fRadiusIN, fY0);
           MoveTo (fX0, fY0);
           LineTo (fX0 + fPn2.X, fY0 - fPn2.Y);
           // ------------------------
           //    
           Pen.Width   := 1;
           Pen.Color   := clBlack;
           Brush.Style := bsClear;
           //  
           Ellipse(fX0 - fRadiusPIE, fY0 + fRadiusPIE,
                   fX0 + fRadiusPIE, fY0 - fRadiusPIE);
        end;
        // -------------------------------------
     end;
     // ----------------------------------------
     //     
     BmpShowMarks(RqBmp, RqValue);
     // ----------------------------------------
     //   
     with RqBMP.Canvas
     do begin
        Font.Color  := clBlack;
        Font.Style  := [fsBold];
        Brush.Style := bsClear;
        //      
        WTxtH := TextHeight('0');
        WTxtW := TextWidth(Measure);
        //  
        if ScopeStyle = ssPie
        then begin
            if fPn2.Y >= 0
            then begin
               //   ( )
               wYV := 2;  wTM := wYV + WTxtH;
            end  else begin
               //  
               wYV := - WTxtH - 4; wTM := wYV - WTxtH;
            end;
            //   
            TextOut(fX0 - 24, fY0 + wYV, Format('%6.3f',[RqValue]));
            //  
            Font.Style  := [];
            TextOut(fX0 - (WTxtW div 2), fY0 + wTM, Measure);
        end;
        //  
        if ScopeStyle = ssArc
        then begin
            //      Y
            wYV := fY0 - (WTxtH div 2);
            //   
            TextOut(fX0 - fRadiusIN + 6, wYV,
                    Format('%8.4f',[RqValue]));
            //  
            Font.Style  := [];
            wTM := fY0 + WTxtH - (WTxtH div 2);
            TextOut(fX0 - (WTxtW div 2), wTM, Measure);
            //  
            wName := Trim(ScopeName);
            if Length(wName) > MaxNameLen
            then wName := copy(wName, 1, MaxNameLen);
            wTM := fY0 - WTxtH - (WTxtH div 2);
            WTxtW := TextWidth(wName);
            TextOut(fX0 - (WTxtW div 2), wTM, wName);
        end;
     end;
end;
// ----------------------------------------------------------------
//        
procedure TRingScope.ReSizeScope();
begin
    //      
    //    
    ScopeSize(RingMinSize, RingMinSize);
end;

// ----------------------------------------------------------------
//   
procedure TRingScope.PaintToBmp(Bmp : TBitMap);
begin
    //     
    BmpRingClear(Bmp);
    //    
    BmpShowRing(Bmp, Value);
end;

// ================================================================
//   TRingScope. 
// ================================================================

end.
